#ifndef		DEFS_PMAIL_H
#define		DEFS_PMAIL_H

#define		RCFILE		"~/.pmailrc" 
#define		HOMEBOX		"~/Mail/mbox"
#define		TMPFILE		"/tmp/pmailXXXXXX"

#define		PMAILVER		"0.7.4"


#define		RC_DEFAULT			"default"
#define		RC_VERBOSE			"verbose"
#define		RC_TOPNUM			"topnumber"
#define		RC_TIMEOUT			"timeout"
#define		RC_POP3HOST			"pop3host"
#define		RC_DEBUGLVL			"debuglevel"
#define		RC_SMTP				"smtp"
#define		RC_OUTBOX			"outbox"
#define		RC_SENDER			"sender"
#define		RC_TOPSTYLE			"topstyle"
#define		RC_BAKBOX			"bakbox"
#define		RC_DEALSENT			"dealsent"
#define		RC_SIGNATURE		"signature"
#define		RC_LOGFILE			"logfile"
#define		RC_LOGLIMIT			"loglimit"
#define		RC_PIPETO			"pipeto"
#define		RC_HEADER			"header"
#define		RC_SIZELIMIT		"sizelimit"

#define		DEF_POP3			"pop3"
#define		DEF_SMBOX			"sbox"
#define		DEF_TEMPLATE		"templ"
#define		DEF_VERSION			"version"
#define		DEF_HELP			"help"

#define		DEF_SIMPLE			"simple"
#define		DEF_COMPLEX			"complex"
#define		DEF_SMART			"smart"

#define		DEF_HOLD			"hold"
#define		DEF_DELETE			"delete"
#define		DEF_BACKUP			"backup"

#define		DEF_YES				"yes"
#define		DEF_NO				"no"


#define		S_COMMON		0
#define		S_START			1
#define		S_FROM			2
#define		S_TO			3
#define		S_BCC			4
#define		S_BODY			5	


#define		YES				1
#define		NO				0
#define		ON				1
#define		OFF				0

#define		OK				0
#define		LOGIN_FAIL		2
#define		FAILURE			-1
#define		MISSOCKET		-2
#define		MISCONNECT		-3
#define		MISANSWER		-4
#define		LOOKERRNO		-5
#define		LOWMEMORY		-6
#define		OPENFILERR		-7
#define		CREATEFAIL		-8
#define		MISHOSTS		-9


#define		OVER			0
#define		CONTINUED		1

#define		GETMAIL			0
#define		SENDMAIL		1
#define		TEMPLATE		2
#define		STREAM			3
#define		HELP			4
#define		VERSION			5

#define		SIMPLETOP		0
#define		COMPLEXTOP		1
#define		SMARTOP			2

#define		SENTHOLD		0
#define		SENTDELETE		1
#define		SENTBACKUP		2

#define		E_NORCFILE		1
#define		E_INVITEM		2
#define		E_INT			3

#define		POP3_PORT		110
#define		SMTP_PORT		25
#define		MAXHOSTS		32
#define		SVRBUFSIZ		512
#define		NETBUF			1024
#define		LOGLIMIT		10240
#define		HEADEREXT		64

#define		POP3_HOST_L		80
#define		POP3_LOGID_L	16
#define		POP3_LOGPASS_L	16
#define		POP3_MAILBOX_L	256

#define		OP_DOWNLOAD		'd'
#define		OP_CHECK		'c'
#define		OP_FETCH		'f'
#define		OP_TOPHEAD		't'
#define		OP_HELP			'h'
#define		OP_REMOVE		'r'

struct		POP3_SERVER		{
	char	host [ POP3_HOST_L ];
	char	logid [ POP3_LOGID_L ];
	char	logpass [ POP3_LOGPASS_L ];
	char	mailbox [ POP3_MAILBOX_L ];
	char	operate;
};

struct		DLVTO		{
	char	*host;
	struct	DLVTO	*next;
};

struct		SENDTO		{
	int		id;				/* serial No. */
	char	*from;			/* mail from */
	struct	DLVTO	*to;	/* send and copy to */
	long	mleng;			/* content length */
	long	msgseek;
	struct	SENDTO	*next;
};

extern int  errno;

#ifdef		DEBUG

  #define	reporter(func,x)  { \
  		if (x)  { \
  			fprintf(stderr, "!%s: %s\n", (func), (x)); \
  			fflush(stderr); \
  		} \
  }
  
  #define	lowmsg(msg)  { \
	  fprintf msg ; \
	  fflush(stderr); \
  }	  

#else

  #define	reporter(func,x)
  #define	lowmsg(msg)

#endif

  
#define		pfree(ptr)	{\
    if ((ptr) != NULL)  free(ptr); \
    ptr = NULL; \
}

#define		pfclose(ptr)  { \
	if ((ptr) != NULL)  fclose(ptr); \
	ptr = NULL; \
}

#define		chop(buf)	(buf[strlen(buf)-1] = '\0')
  
/* these globle varity is defined in the main.c */ 
  
extern  struct	POP3_SERVER		hosts[MAXHOSTS];
extern  int		hostcnt;
extern  char	defop;
extern  int		topn;
extern	int		topstyle;
extern	int		*mailset;
extern	int		sizelimit;

extern  char	*smtpsvr;
extern	char	*outbox;
extern	char	*bakbox;
extern	char	*signature;
extern	int		dealsent;

extern	char	*subject;
extern	char	*cc;
extern	char	*bcc;
extern	char	*toaddr[];
extern	char	*pipeto;

extern  int		timeout;
extern  int		verbose;
extern	int		dowhat[];
extern	int		log;
extern	int		headers;
extern	char	*headlst[];
extern  int		debuglvl;		/* for debug information */


/* see pop3.c */

void pop3client(void);

/* see smtp.c */

int smtpclient(void);

/* see stream.c */

int sendstream(void);

/* see util.c */

int  OpenSocket(char *host, int port);
int AskAnswer(FILE *sfp, int socket, char *buf, int leng);
int  readlh(FILE *sfp, char *buf, int n);
int  readline(FILE *sfp, char *buf, int leng);
int  writeline(int socket, char *buf);
int  linesend(int socket, char *buf);
int  sflush(int socket);
void ErrReport(int, char *);
int strnicmp(char *, char *, int);
int isblankline(char *);
void illustrate(int, int, int);
void combpath(char *);
char *emailaddr(char *faddr);
char *getsender(void);
void elog(char *, char *);
void urgexit(char *, int);
void ReleaseVarity(void);
char *timenow(void);

#endif
