
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<signal.h>
#include	<sys/stat.h>
#include	<sys/types.h>
#include	"defs.h"



static int	ssock = -1;
static FILE	*sfp = NULL;

static FILE	*ssflp = NULL;

static char	*sender = NULL;
static char	sstmpfile[80];



static char *readstdin(char *buf);
static FILE *silofile(void);
static void getsubject(void);
static void SetSender(void);
static void backupmail(void);
static void ssend();
static void streamstop();


int sendstream(void)
{
	int		i;
	char	buf[SVRBUFSIZ], *p, temp[SVRBUFSIZ];
	
    signal(SIGHUP, streamstop);
    signal(SIGINT, streamstop);
    signal(SIGQUIT, streamstop);
    signal(SIGTERM, streamstop);
    signal(SIGALRM, streamstop);
							

#ifndef		SSQUIT
  #define	SSQUIT(what)	{\
	  ssend(); \
	  return(what); \
  }
#endif
	
	SetSender();
	if ((ssflp = silofile()) == NULL)  return FAILURE;
	
    printf("Trying SMTP host [%s] ...\n", smtpsvr);
	ssock = OpenSocket(smtpsvr, SMTP_PORT);
    if (ssock < 0)  SSQUIT(MISSOCKET);
	sfp = fdopen(ssock, "r");
	elog("sstream", "open immediately-delivery mode");
    if (readlh(sfp, buf, SVRBUFSIZ) <= 0)  SSQUIT(MISCONNECT);
    if (verbose == ON)  printf("<< %s", buf);
    if (atoi(buf) != 220)  SSQUIT(MISANSWER);
	
    sprintf(buf, "HELO %s", cuserid(NULL));
    if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
		SSQUIT(MISCONNECT);
	}
    if (atoi(buf) != 250)  {
		AskAnswer(sfp, ssock, "QUIT", 0);
		printf("HELO: %s", buf);
		SSQUIT(MISANSWER);
	}
				 
	sprintf(buf, "MAIL FROM:<%s>", emailaddr(sender));
    if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
		SSQUIT(MISCONNECT);
	}
	if (atoi(buf) != 250)  {
		AskAnswer(sfp, ssock, "QUIT", 0);
		printf("MAIL FROM [%s]: %s", sender, buf);
		SSQUIT(MISANSWER);
	}
		
	for (i = 0; toaddr[i] != NULL; i++)  {
        sprintf(buf, "RCPT TO:<%s>", emailaddr(toaddr[i]));
        if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
			SSQUIT(MISCONNECT);
		}
        if (atoi(buf) != 250)  {
			elog(toaddr[i], buf);
			printf("RCPT TO [%s]: %s", emailaddr(toaddr[i]), buf);
		}
    }
	
	sprintf(temp, "%s,%s", (cc == NULL)?"":cc, (bcc == NULL)?"":bcc);
	p = strtok(temp, ",");
	do  {
		if (p == NULL)  break;
		if (isblankline(p))  continue;
		sprintf(buf, "RCPT TO:<%s>", emailaddr(p));
	    if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
			SSQUIT(MISCONNECT);
		}
	    if (atoi(buf) != 250)  {
			elog(p, buf);
			printf("RCPT TO [%s]: %s", p, buf);
		}
	} while ((p = strtok(NULL, ",")) != NULL);
	
	sprintf(buf, "DATA");
    if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
		SSQUIT(MISCONNECT);
	}
    if (atoi(buf) != 354)  {
		AskAnswer(sfp, ssock, "QUIT", 0);
		printf("DATA: %s", buf);
		SSQUIT(MISANSWER);
	}
		
	fgets(buf, SVRBUFSIZ, ssflp);
	*buf = '.', p = buf + 1;
	while (fgets(p, SVRBUFSIZ-1, ssflp) != NULL)  {
		if (*p == '.')  linesend(ssock, buf);
		else  linesend(ssock, p);
	}

	strcpy(buf, "\r\n.");
	if (AskAnswer(sfp, ssock, buf, SVRBUFSIZ) != OK)  {
		SSQUIT(MISCONNECT);
	}
	if (atoi(buf) != 250)  {
		AskAnswer(sfp, ssock, "QUIT", 0);
		printf("DOT: %s", buf);
		SSQUIT(MISANSWER);
	}
	AskAnswer(sfp, ssock, "QUIT", 0);
	printf(&buf[4]);
	if ((dealsent == SENTBACKUP) && (bakbox != NULL))  backupmail(); 
	SSQUIT(OK);
}
					
				
/* buf size should no less than SVRBUFSIZ bytes */
static char *readstdin(char *buf)
{
	char	temp[SVRBUFSIZ];
	
	if (fgets(temp, SVRBUFSIZ - 1, stdin) == NULL)  return NULL;
	
	if (!strncmp(temp, "From ", 5))  sprintf(buf, ">%s", temp);
	else strcpy(buf, temp);
	return buf;
}
	
				
static FILE *silofile(void)
{
	char	buf[SVRBUFSIZ];
	FILE	*fp = NULL;
	int		i, cnt = 0;
	
	strcpy(sstmpfile, TMPFILE);
	fp = fdopen(mkstemp(sstmpfile), "w+t");
	if (fp == NULL)  return NULL;
	
	if (isatty(0))  {
		getsubject();
		fprintf(stderr, "Use CTRL-D to terminate letter\n");
	}
	fprintf(fp, "From %s %s\n", emailaddr(sender), timenow());
	fprintf(fp, "From: %s\n", sender);
	fprintf(fp, "To: ");
	for (i=0; toaddr[i] != NULL; i++)  {
		fprintf(fp, "%s", toaddr[i]);
		if (toaddr[i+1] == NULL)  fprintf(fp, "\n");
		else  fprintf(fp, ",");
	}
	for (i=0; i<headers; i++)  fprintf(fp, "%s\n", headlst[i]);
	if (subject != NULL)  fprintf(fp, "Subject: %s\n", subject);
	if (cc != NULL)  fprintf(fp, "Cc: %s\n", cc);
	fprintf(fp, "\n");
	fclose(fp);
	
	if (pipeto != NULL)  {
		sprintf(buf, "%s >> %s", pipeto, sstmpfile);
		if ((fp = popen(buf, "w")) == NULL)  {
			elog("pipeopen", buf);
			pfree(pipeto);
		}
	}
	if (pipeto == NULL)  {
		if ((fp = fopen(sstmpfile, "at")) == NULL)  {
			fprintf(stderr, "Cannot open temp file\n");
			return NULL;
		}
	} 
		
	while(1)  {
		if (readstdin(buf) == NULL)  break;
		fputs(buf, fp);
		cnt += strlen(buf);
	}
	if (signature != NULL)  {
		fputs(signature, fp);
		cnt += strlen(signature);
	}
	if (cnt == 0)  {
		fprintf(stderr, "No message, padding the body with a CR\n");
		fputs("\n", fp);
	}
	
	if (pipeto == NULL)  fclose(fp);  else  pclose(fp);
	return  fopen(sstmpfile, "r");
}
	

static void getsubject(void)
{
	char	buf[SVRBUFSIZ];
	
	if (subject == NULL)  {
		fprintf(stderr, "Subject: ");
		fgets(buf, SVRBUFSIZ, stdin);
		chop(buf);
		if (!isblankline(buf))  {
			subject = (char*) malloc(strlen(buf) + 1);
			if (subject == NULL)  urgexit("sendstream", LOWMEMORY);
			strcpy(subject, buf);
		}
	}
}


static void SetSender(void)
{
	char	buf[SVRBUFSIZ];
	
	sender = getsender();
	while (sender == NULL)  {
		fprintf(stderr, "Your address: ");
		fgets(buf, SVRBUFSIZ, stdin);
		chop(buf);
		if (!isblankline(buf))  {
			sender = (char*) malloc(strlen(buf) + 1);
			if (sender == NULL)  urgexit("sendstream", LOWMEMORY);
			strcpy(sender, buf);
		}
	}
}	


static void backupmail(void)
{
	FILE	*fpbak;
	char	buf[SVRBUFSIZ];
	
	if ((fpbak = fopen(bakbox, "at")) != NULL)  {
		rewind(ssflp);
		while(fgets(buf, SVRBUFSIZ, ssflp) != NULL)  {
			fputs(buf, fpbak);
		}
		fclose(fpbak);
	}
}


static void ssend(void)
{
	if (sfp != NULL)  pfclose(sfp);
	if (ssock != -1)  {
		close(ssock);
		ssock = 0;
	}
	if (ssflp != NULL)  pfclose(ssflp);
	unlink(sstmpfile);
}


static void streamstop()
{
	ssend();
	ReleaseVarity();
	exit (E_INT);
}


