
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<netdb.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<errno.h>
#include	<time.h>
#include	"defs.h"


static	char	netbuf[NETBUF];
static	int		nbidx = 0;

static void transferate(struct timeval *, int, char *);


/*
	OpenSocket --
   
		Create a socket, and make a TCP connection in specified 
	"port" of the "host". 
		The return value is a discription of the socket, or < 0 
	when it fails.
*/ 
int  OpenSocket(char *host, int port)	
{
	struct	sockaddr_in		sa;
	struct	hostent			*hp;
	int		s;

	bzero(&sa, sizeof(sa));
	sa.sin_family = AF_INET;
	if ((sa.sin_addr.s_addr = inet_addr(host)) == INADDR_NONE)  {		
		if ((hp = gethostbyname(host)) == NULL)  return  MISHOSTS;
		bcopy(hp->h_addr, (char*) &sa.sin_addr, hp->h_length);
		sa.sin_family = hp->h_addrtype;
	}
	if ((s = socket(sa.sin_family, SOCK_STREAM, 0)) < 0)  {
		return MISSOCKET;
	}
	sa.sin_port	= htons(port);
	if (connect(s, (struct sockaddr*)&sa, sizeof(sa)) < 0)  {
		close(s);
		return MISCONNECT;
	}
	return (s);
}


/*
	AskAnswer --
   
		It achives a two-way conversation with server host, which
	means sending a request to and waiting for an answer from the 
	server host. The "sfp" and "socket" in the parameter list are
	in fact the same. One is the high level file type, another is
	the low level file description.
	
		The "buf" is used to store the request. DO NOT PUT A '\n'
	AT THE END OF THE REQUEST! The function should do it itself.
	The "leng" specifies the length of the "buf". The answer will
	send back into it; so the original request will wipe out. But
	if the "leng" is set as 0 or less 0, the answer should be dis-
	carded for reservering the original request.
*/
int AskAnswer(FILE *sfp, int socket, char *buf, int leng)
{
	char	temp[SVRBUFSIZ];
	int		result;
	
	if (verbose == ON)  printf("-> %s\n", buf);
	sprintf(temp, "%s\r\n", buf);
	result = writeline(socket, temp);
	
	/*printf("-> %s has been sent, result is %d\n", buf, result);*/

	if (result != OK)  return  result;
	
	result = readlh(sfp, temp, SVRBUFSIZ);
	if (leng > 0)  strncpy(buf, temp, leng);
	if (verbose == ON)  printf("<< %s", temp);
	if (result < 0)  return result;
	
	while (temp[3] == '-')  {		/* just for SMTP feature */
		result = readlh(sfp, temp, SVRBUFSIZ);
		if (verbose == ON)  printf("<< %s", temp);
		if (result < 0)  return result;
	}
	return OK;
}


/* 
   readlh -- 
   
		Read a line of text from a stream. If more than n-1  
	characters are read without a line terminator ('\n'),  
	discard characters until line terminator is located. 
*/
int  readlh(FILE *sfp, char *buf, int n)
{
	int		i, ch = 0;
	
	buf[n-2] = '\n',  buf[n-1] = '\0';
	for (i = 0; i < n - 2; i++)  {
		alarm(timeout);
		ch = fgetc(sfp);
		alarm(0);
		buf[i] = ch;
		if (ch == '\n')  {
			buf[i+1] = '\0';
			break;
		}
		if (ch == EOF)  {
			buf[i] = '\0';
			return MISSOCKET;
		}
	}
	while ((ch != '\n')&&(ch !=EOF)) {
		alarm(timeout);
		ch = fgetc(sfp);
		alarm(0);
	}
    return strlen(buf);
}



/*
   readline -- read a line data from socket and change the DOS style
   line terminator ("\r\n") into UNIX style ('\n').
*/ 
int  readline(FILE *sfp, char *buf, int leng)
{
	char	*p;

	alarm(timeout);
	p = fgets(buf, leng, sfp);
	alarm(0);
	if (p == NULL)  return -1;
	for (p=buf; *p; p++)  if (*p == '\r')  {
		*p++ = '\n';
		*p = '\0';
		break;
	}
	return strlen(buf);
}
		

/*
   writeline -- write a string into socket without buffering, sending
   immediatly.
*/
int  writeline(int socket, char *buf)
{
	int		result;
	
	linesend(socket, buf);
	result = sflush(socket);
	if (result <= 0)  return  -1;
	return OK;	
}


/*
   linesend() sflush() --
   
   linesend() is used to buffer the ready-send data.
   sflush() is very like the fflush() function, to oblige the program
   sent the data in the buffer at once
*/ 
int  linesend(int socket, char *buf)
{
	int		c, r = OK;
	
	if (strlen(buf) > NETBUF)  {
		sflush(socket);
		alarm(timeout);
		r = write(socket, buf, strlen(buf));
		alarm(0);
	} else { 
		if ((nbidx + strlen(buf)) > NETBUF)  r = sflush(socket);
		for (c=0; (nbidx < NETBUF) && buf[c]; nbidx++, c++)  {
			netbuf[nbidx] = buf[c];
		}
	}
	return r;
}

int  sflush(int socket)
{
	int		r = OK;
	
	if (nbidx != 0)  {
		alarm(timeout);
		r = write(socket, netbuf, nbidx);
		alarm(0);
		nbidx = 0;
	}
	return r;
}
			


void illustrate(int cur, int mailength, int dotRange)
{
	static	int		dotted, dotall;
	static	int		gotten, expect;
	static	int		lastgot;
	static	struct	timeval	start, last;
	char	rate[16];
	int		n;
	
	if (mailength != 0)  {
		dotted = gotten = lastgot = 0;
		expect = mailength;
		dotall = dotRange;
		gettimeofday(&start, (struct timezone*) NULL);
		last = start;
	} else  if (cur == 0)  {
		for (; dotted < dotall; dotted++)  putchar('.');
		transferate(&start, gotten, rate);
		printf(rate);
		putchar('\n');
	} else {
		gotten += cur;
		n = (dotall * gotten) / expect;
		if ((dotted < n) && (dotted < dotall))  {
			for (; dotted < n; dotted++)  putchar('.');
			transferate(&last, gotten - lastgot, rate);
			lastgot = gotten;
			printf(rate);
			for (n=0; n<strlen(rate); n++)  putchar('\b');
		}
	}
	fflush(stdout);
}


static void transferate(struct timeval *last, int increased, char *buf)
{
	char	*degree[] = { "bps", "K/s", "M/s", "G/s" };
	int		i, m = 0, n;
	struct	timeval	now;
	
	strcpy(buf, "  violent");
	now = *last;
	gettimeofday(last, (struct timezone *) NULL);
	now.tv_sec  = last->tv_sec - now.tv_sec;
	if (last->tv_usec < now.tv_usec)  {
		now.tv_sec --;
		now.tv_usec = last->tv_usec + 1000000 - now.tv_usec;
	} else now.tv_usec = last->tv_usec - now.tv_usec;
	if (now.tv_sec < 0)  return;
	
	if ((now.tv_sec == 0) && (now.tv_usec == 0))  return;
	if (now.tv_sec > 10)  {
		n = increased / now.tv_sec;
	} else if (increased < 2000)  {
		n = increased * 1000000 / (now.tv_sec * 1000000 + now.tv_usec);
	} else if (now.tv_usec > 1000)  { 
		n = increased * 1000 / (now.tv_sec * 1000 + now.tv_usec / 1000);
	} else return;
	if (n < 0)  return;
	
	for (i=0; i<4; i++)  {
		if (n < 1000)  break;
		m = n % 1000;
		n = n / 1000;
	}
   	if (i == 0)  sprintf(buf, " %4d %s", n, degree[0]);
	else  if (n < 10)  sprintf(buf, " %d%03d %s", n, m, degree[i-1]);
	else  if (n < 100) sprintf(buf, " %d.%d %s", n, m/100, degree[i]);
	else  sprintf(buf, "%4d %s", n, degree[i]);
}



int strnicmp(char *sour, char *dest, int leng)
{
	int		i;
	char	a, b;

#ifdef	strncasecmp
	
	return strncasecmp(sour, dest, leng);
	
#else
	
	for (i=0; i<leng; i++, sour++, dest++)  {
		if ((*sour < 'a') || (*sour > 'z'))  a = *sour;
		else  a = *sour - 'a' + 'A';
		if ((*dest < 'a') || (*dest > 'z'))  b = *dest;
		else  b = *dest - 'a' + 'A';
		if (a != b)  return 1;
		if (a == '\0')  break;
	}
	return 0;
	
#endif
}


int isblankline(char *buf)
{
	while (*buf)  if (*buf > ' ')  return NO;  else  buf++;
	return YES;
}


void combpath(char *sour)
{
	char	buf[SVRBUFSIZ], comb[SVRBUFSIZ], *p;
	
	strcpy(buf, sour);
	if (*buf == '/')  strcpy(comb, "/");  else  *comb = '\0';
	if ((p = strtok(buf, "/")) == NULL)  return;
	do {
		if (!strcmp(p, "~"))  strcat(comb, getenv("HOME"));
		else  strcat(comb, p);
		strcat(comb, "/");
	} while ((p = strtok(NULL, "/")) != NULL);
	if (sour[strlen(sour) - 1] != '/') 
		comb [strlen(comb) - 1] = '\0';
	strcpy(sour, comb);
}	
	

char *emailaddr(char *faddr)
{
	char	*p;
	static	char	buf[SVRBUFSIZ];
	
	strcpy(buf, faddr);
	if ((p = strchr(buf, '<')) == NULL)  return faddr;
	faddr = ++p;
	if ((p = strchr(faddr, '>')) == NULL)  return faddr;
	*p = '\0';
	return faddr;
}


char *getsender(void)
{
	int		i;
	
	for (i=0; i<headers; i++)  {
		if (!strncmp(headlst[i], "Sender: ", 8))  break;
	}
	if (i == headers)  return NULL;
	return &headlst[i][8];
}
	

char *timenow(void)
{
	time_t	tm;
	static	char	buf[32];
	
	time(&tm);
	strcpy(buf, ctime(&tm));
	chop(buf);
	return buf;
}


void elog(char *who, char *what)
{
	char	buf[SVRBUFSIZ];
	
	if (log < 0)  return;
	sprintf(buf, "%s %s: %s\n", timenow(), who, what);
	write(log, buf, strlen(buf));
}
	

void ReleaseVarity(void)
{
	pfree(smtpsvr);
	pfree(outbox);
	pfree(bakbox);
	pfree(subject);
	pfree(cc);
	pfree(bcc);
	pfree(mailset);
	pfree(signature);
	pfree(pipeto);
	while(headers) free(headlst[--headers]);
	if (log > 2)  {
		close(log);
		log = -1;
	}
}


/*
	this function merely give out an error message. When you need a
	prompt but unbreak the program, use it.
*/
void ErrReport(int flag, char *s)
{
	char	*cp, buf[SVRBUFSIZ];
	
	switch (flag)  {
	case MISHOSTS:
		cp = "%s: cannot resolve the host's name";
		break;
		
	case MISSOCKET:
		cp = "%s: cannot open the socket";
		break;
		
	case MISCONNECT:
		cp = "%s: fail to connect the host";
		break;
		
	case MISANSWER:
		cp = "%s: server reply an unmarch answer";
		break;

	case LOGIN_FAIL:
		cp = "%s: access denied";
		break;
		
	case LOWMEMORY:
		cp = "%s: insufficent memory";
		break;
		
	case LOOKERRNO:
		switch (errno)  {
		case EINTR:
			cp = "%s: interrupted by a signal before any data was read";
			break;
			
		case EINVAL:
			cp = "%s: unable reading from the net object";
			break;
			
		case EFAULT:
			cp = "%s: buffer is outside the accessible address space";
			break;
			
		default:
			cp = "%s: connection is lost";
			break;
		}
		break;
	
	default:
		cp = "%s: unknown error flag";	
	}
	sprintf(buf, cp, s);
	elog("pmail", buf);
	printf("%s.\n", buf);
}
		  

void urgexit(char *msg, int flag)
{
	char	*cp, buf[SVRBUFSIZ];
	
	switch (flag)  {
	  case LOWMEMORY:
		  cp = "%s: insufficent memory";
		  break;
		  
	  default:
		  cp = "%s: urgent exit";
	}
	sprintf(buf, cp, msg);
	elog("exited", buf);
	printf("%s.\n", buf);
	exit (flag);
}

