/*-
 * Copyright (c) 1997        Gabor Kincses <gabor@acm.org>
 *               1997 - 2001 Brian Somers <brian@Awfulhak.org>
 *          based on work by Eric Rosenquist
 *                           Strata Software Limited.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $OpenBSD: chap_ms.c,v 1.10 2001/08/10 17:43:40 brian Exp $
 */ 

/*
  Modified by Patrik Karlsson <patrik.karlsson@ixsecurity.com>
  2001-11-03
*/

#include "crypto.h"
#include <string.h>
#include <sys/types.h>

#ifdef WIN32
typedef unsigned char u_char;
#endif

static u_char Get7Bits(UCHAR *input, int startBit) {
  register unsigned int	word;
    
  word  = (unsigned)input[startBit / 8] << 8;
  word |= (unsigned)input[startBit / 8 + 1];
  
  word >>= 15 - (startBit % 8 + 7);

  return word & 0xFE;
}

// Make the key
static void MakeKey(UCHAR *key, UCHAR *des_key) {

  des_key[0] = Get7Bits(key,  0);
  des_key[1] = Get7Bits(key,  7);
  des_key[2] = Get7Bits(key, 14);
  des_key[3] = Get7Bits(key, 21);
  des_key[4] = Get7Bits(key, 28);
  des_key[5] = Get7Bits(key, 35);
  des_key[6] = Get7Bits(key, 42);
  des_key[7] = Get7Bits(key, 49);
  
  des_set_odd_parity((des_cblock *)des_key);

}

// Do the DesEncryption
void DesEncrypt(UCHAR *clear, UCHAR *key, UCHAR *cipher) {

  des_cblock		des_key;
  des_key_schedule	key_schedule;
  
  MakeKey(key, des_key);
  des_set_key(&des_key, key_schedule);
  des_ecb_encrypt((des_cblock *)clear, (des_cblock *)cipher, key_schedule, 1);

}

void mkResponse(UCHAR **ntlmhash, UCHAR hash[MD4_SIGNATURE_SIZE], UCHAR* challenge) {

  u_char              p21[21];
  UCHAR               ntlm_response[24];

  memset(p21, 0, 21);
  memcpy(p21, hash, 16);

  DesEncrypt(challenge, p21 +  0, ntlm_response + 0);
  DesEncrypt(challenge, p21 +  7, ntlm_response + 8);
  DesEncrypt(challenge, p21 + 14, ntlm_response + 16);

  memcpy(*ntlmhash, ntlm_response, 24);

}

