/* 
   SMBProxy
   Copyright (C) Patrik Karlsson <patrik.karlsson@ixsecurity.com> 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "debug.h"

void dumpGUID(SMBDATA *pData) {      

  int i;

  printf("INFO: Server GUID seems to be : ");
  for ( i = 0; i<sizeof(pData->GUID); i++ ) {
    printf("%X", pData->GUID[i]);
  }
  printf("\n");

}

void dumpChallenge(SMBDATA *pData) {

  int i;

  fprintf(stdout, "INFO: Challenge seems to be: ");
  for ( i=0; i<sizeof(pData->challenge); i++ ) {
    fprintf(stdout, "%X", pData->challenge[i]);
  }
  
  fprintf(stdout, "\n");

}

void dumpResponse(SMBDATA *pData) {

  int i;

  fprintf(stdout, "INFO: Looking for response in buffer : ");
  for (i = 0; i<24; i++) {
    fprintf(stdout, "%X", pData->NTLMResponse[i]);
  }
  fprintf(stdout, "\n");

}

void dumpUID(SMBDATA *pData) {
  
  int nUID = 0;

  nUID = pData->UID[1] * 256;
  nUID += pData->UID[0];
  fprintf(stdout, "INFO: UID seems to be %X\n", nUID);

}

void dumpNewResponse(SMBDATA *pData) {

  int i;

  fprintf(stdout, "INFO: Sending response: ");
  for (i=0; i<24; i++) {
    fprintf(stdout, "%X", pData->newNTLMResponse[i]);
  }
  fprintf(stdout, "\n");

}
