/* 
   SMBProxy
   Copyright (C) Patrik Karlsson <patrik.karlsson@ixsecurity.com> 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _CONSTANTS_H
#define _CONSTANTS_H

const char *SMBPROXY_VERSION = "V1.0.0";

const uchar SMB_NEGPROT   = 0x72;
const uchar SMB_SETUPANDX = 0x73;

const int OFFSET_UID       = 32;
const int OFFSET_PROTOVER  = 37;
const int OFFSET_BYTECOUNT = 43;
const int OFFSET_SECURITYBLOB_LENGTH = 51;
const int OFFSET_SECURITYBLOB = 63;

const int OFFSET_SMBNEGPROT_KEYLEN = 70;
const int OFFSET_SMBNEGPROT_CHALLENGE = 73;
const int OFFSET_SMBSETUPANDX_USERNAME_WINNT40 = 114;
const int OFFSET_SMBSETUPANDX_ANSIPWLENGTH = 51;
const int OFFSET_SMBSETUPANDX_NTLM_RESPONSE = 65;

const int OFFSET_CHALLENGE = 71;
const int OFFSET_GUID_SIZE = 71;
const int OFFSET_GUID      = 73;
//const int OFFSET_NTLMHASH  = 179;
const int OFFSET_COMMAND   = 8;
const int OFFSET_STATUS    = 9;

//const int PROTO_WIN2000    = 5;
const int WIN2000 = 5;
const int WINNT40 = 4;

/*
  Different levels of Logging
  0: Only log errors
  .
  .
  .
  4: Log the everything 
*/
const int LOG_ERROR   = 0;
const int LOG_WARNING = 1;
const int LOG_INFO    = 2;
const int LOG_TRACE   = 3;
const int LOG_DEBUG   = 4;

#endif
