#!/usr/bin/perl
# 
#   SMBProxy
#   Copyright (C) Ian Vitek <ian.vitek@ixsecurity.com> 2001
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
die "\nConvert L0phtcrack3 files to pwdump format\
(C) Ian Vitek <ian.vitek\@ixsecurity.com> 2001\
usage: $0 lc3-file\n\n" if (! defined $ARGV[0]);

undef $/;
open(LC3FILE,$ARGV[0]) or die "Can not open LC3 file $ARGV[0]\n$!\n";
binmode(LC3FILE);
($start)=<LC3FILE>=~/^(.+\x00\x00\xf4\x01\x00\x00)/s;
die "Are you sure that $ARGV[0] is a LC3 file?\n" if(length $start<1);
seek(LC3FILE,(length $start)-4,0);
while( read(LC3FILE,$slice,896) ) {
  ($uid,$user)=$slice=~/^([^\x00]{2})\x00\x00([^\x00]+)/s;
  ($guessed,$LANMANhash,$NThash,$pw1,$pw2)=$slice=~/^.{648}(.{2})\x00\x00(.{16})(.{16}).{56}(.{14})\x00(.{14})/s;
#
# If $guessed is \x85\x00 or \x87\x00 or \x45\x00
# the password is not guessed!
#
    $uid=~s/(.)(.)/sprintf("%d",ord ($2)*256 + ord($1) )/seg;
    $LANMANhash=~s/(.)/sprintf("%02X",ord $1)/seg;
    $NThash=~s/(.)/sprintf("%02X",ord $1)/seg;
    print("$user\:$uid\:$LANMANhash\:$NThash\:\:\:\n");
}
