/* 
   SMBProxy
   Copyright (C) Patrik Karlsson <patrik.karlsson@ixsecurity.com> 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _SMBPROXY_H_
#define _SMBPROXY_H_

typedef unsigned char uchar;
typedef char bool;

typedef struct pwdump {
  char   username[64];
  int    nUID;
  char   LMHash[34];
  char   NTLMHash[32];
  struct pwdump *next;
} PWDUMP;

typedef struct arguments {
  char  listenIP[16];
  char  serverIP[16];
  int   nProxyPort;
  char  pass[64];
  FILE  *pPWDumpFile;
  int   nLogLevel;
} ARGS;

typedef struct smbdata {
  bool bGotChallenge;
  uchar *NTLMHash;
  uchar *NTLMResponse;
  uchar *newNTLMResponse;
  uchar challenge[8];
  char  pass[64];
  uchar GUID[16];
  uchar UID[2];
  int   nServerOS;
  PWDUMP *pPWDump;
} SMBDATA;

typedef struct smbpacket {
  uchar SMBCommand;
  uchar GUID[16];
  uchar UID[2];
} SMBPACKET;


#endif 
