/* 
   SMBProxy
   Copyright (C) Patrik Karlsson <patrik.karlsson@ixsecurity.com> 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "util.h"

// uppercase
char *ucase(uchar *src) {

  unsigned int i;
  uchar *dest;
  
  dest = (uchar *) malloc ( strlen(src) );

  memset(dest, 0, strlen(src));

  for ( i=0; i<strlen(src); i++ ) {
    if ( src[i]>=97 && src[i] <= 122 ) {
      dest[i] = src[i]-32;
    }
    else if ( src[i] == 148 )
      dest[i] = 153;
    else if ( src[i] == 134 )
      dest[i] = 143;
    else if ( src[i] == 132 )
      dest[i] = 142;
    else {
      dest[i] = src[i];
    }
  }

  memcpy(src, dest, strlen(src));
  free(dest);

  return src;
}


PWDUMP *addUser(PWDUMP **pPWDump, PWDUMP *pNewPWDump) {

  PWDUMP *pNew;

  pNew = (PWDUMP *) malloc(sizeof(PWDUMP));
  memcpy(pNew, pNewPWDump, sizeof(PWDUMP));

  pNew->next = *pPWDump;
  
  return pNew;
}

char *getHashForUser(PWDUMP *pPWDump, char *pUserName) {
  
  char *pUCUser, *pUCPWDumpUser;
  int nLen = 128;

  if ( strlen( pUserName ) == 0 )
    return NULL;

  pUCUser       = (char *) malloc(nLen);
  pUCPWDumpUser = (char *) malloc(nLen);

  // find the right user
  while ( pPWDump ) {

    memset(pUCPWDumpUser, 0, nLen);
    strcpy(pUCUser, ucase(pUserName));
    strcpy(pUCPWDumpUser, ucase(pPWDump->username));
    if ( strcmp(pUCUser, pUCPWDumpUser) == 0 ) {
      free(pUCUser);
      free(pUCPWDumpUser);
      return pPWDump->NTLMHash;
    }

    pPWDump = pPWDump->next;

  }
  
  free(pUCUser);
  free(pUCPWDumpUser);

  return NULL;
}

void freePWDump(PWDUMP *pPWDump) {

  PWDUMP *curr, *rmv;

  curr = pPWDump;

  while ( curr ) {
    rmv = curr;
    curr = curr->next;
    free(rmv);
  }

}

bool isValidFile(FILE *pFile) {

  unsigned int nColon = 0, nPos = 0;
  char line[256];
  
  memset(line, 0, sizeof(line));
  if ( fgets(line, sizeof(line), pFile) != NULL ) {
    while ( nPos < strlen(line) ) {
      if ( line[nPos] == ':' )
	nColon ++;
      nPos++;
    }
    if ( nColon == 6 ) {
      fseek(pFile, 0L, SEEK_SET);
      return TRUE;
    }
    else {
      return FALSE;
    }
  }
  else
    return FALSE;

}

/*
  Translates the HASH from ASCII to BINARY
*/
void translateHash(uchar **NTLMHash, char *cHash) {

  char hex[10];
  int i;
  long n;

  for ( i=0; i<32; i+=2 ) {
    memset(hex, 0, sizeof(hex));
    sprintf(hex, "0x%c%c", cHash[i], cHash[i+1]);
    n = strtol(hex, NULL, 16);
    
    memset(*NTLMHash+(i/2), n, 1);
  }

}

int loadPWDumpFile(FILE *pFile, PWDUMP **pPWDump) {

  PWDUMP *pNewPWDump;
  char line[256];
  int nStart=0, nEnd = 0;
  int nLoaded = 0;
  
  if ( !isValidFile(pFile) ) {
    return FALSE;
  }

  memset(line, 0, sizeof(line));
  pNewPWDump = (PWDUMP *) malloc(sizeof(PWDUMP));

  while ( fgets(line, sizeof(line), pFile) != NULL ) {

    while ( line[nEnd] != ':' )
      nEnd ++;

    memset(pNewPWDump->username, 0, sizeof(pNewPWDump->username));
    memcpy(pNewPWDump->username, line+nStart, (nEnd-nStart));
    nEnd ++;
    nStart = nEnd;

    while ( line[nEnd] != ':' )
      nEnd ++;

    /* Command for copying UID */

    nEnd ++;
    nStart = nEnd;

    while ( line[nEnd] != ':' )
      nEnd ++;

    memset(pNewPWDump->LMHash, 0, sizeof(pNewPWDump->LMHash));
    memcpy(pNewPWDump->LMHash, line+nStart, (nEnd-nStart));

    nEnd ++;
    nStart = nEnd;

    while ( line[nEnd] != ':' )
      nEnd ++;

    memset(pNewPWDump->NTLMHash, 0, sizeof(pNewPWDump->NTLMHash));
    memcpy(pNewPWDump->NTLMHash, line+nStart, (nEnd-nStart));

    //printf("%s:%s\n", pNewPWDump->username, pNewPWDump->NTLMHash);
    memset(line, 0, sizeof(line));

    nEnd = 0;
    nStart = 0;

    *pPWDump = addUser(pPWDump, pNewPWDump);
    nLoaded++;
  }
  
  free(pNewPWDump);
  return nLoaded;

}
