#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<getopt.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	"defs.h"


/* these varity used for POP3 client */

struct	POP3_SERVER		hosts[MAXHOSTS];
int		hostcnt = 0;	/* this is a counter of POP3 server's */
						/* when it is 0, it means no host specified */
char	defop = 0;		/* specified an operating type */
int		topn = 0;		/* when I use TOP command, it defines the */
						/*  top lines of mail */
int		topstyle = SIMPLETOP;
int		*mailset = NULL;	/* a set of mail's number */
int		sizelimit = 0;

/* these varity used for SMTP client */
   
char	*smtpsvr = NULL;			/* SMTP server */
char	*outbox = NULL;		/* the name of outgoing mailbox */
char	*bakbox = NULL;		/* backup mailbox for sent mails */
int		dealsent = SENTHOLD;
char	*signature = NULL;	/* signature file */

/* these varity used for send mail from STREAM */

char	*subject = NULL;
char	*cc = NULL;
char	*bcc = NULL;
char	*toaddr[MAXHOSTS];	/* if it has specified a lot of to-addr */
						/*  in the command line ... NULL for end */

/* misc varity */

int		timeout = 0;
int		verbose = OFF;		/* display verbose information */
int		dowhat[MAXHOSTS];
int		log = -1;
char	*pipeto = NULL;

int		headers = 0;
char	*headlst[HEADEREXT];

static	int		loglimit = LOGLIMIT;

int		debuglvl = 0;		/* it is used to display debug info */
			
  /* level  0: don't display any debug information	*/
  /* level  1: display all of globel varity 		*/
  /* level  2: display the parsing course of RC file */


#define		XMAILER	\
"X-Mailer: pmail %s (Linux). Report bugs to <xuming@bigfoot.com>"

static int Option(int argc, char **argv);
static void fillset(int *set, char *list);
static void parsing(void);
static int Strform(char *buf);
static int rc_default(char *p);
static int rc_timeout(char *p);
static int rc_topnum(char *p);
static void rc_pop3host(char *p);
static void rc_smtp(char *p);
static void rc_outbox(char *p);
static void rc_bakbox(char *p);
static void rc_signature(char *p);
static int rc_dealsent(char *p);
static int rc_topstyle(char *p);
static void rc_sender(char *p);
static void rc_pipeto(char *p);
static int rc_logfile(char *p);
static int rc_loglimit(char *p);
static int rc_sizelimit(char *p);
static void rc_header(char *p);
static int rc_debuglvl(char *p);
static void usage(int flag);

#ifdef		DEBUG

static void testparam(FILE *fp);

#endif


int main(int argc, char** argv)
{
	int		i, result;
	char	*sender;
	FILE	*fp;
	
	umask(077);
	parsing();
	Option(argc, argv);
	setlinebuf(stdout);

	for (i = 0; dowhat[i] >= 0; i++)  {
		switch (dowhat[i])  {
		  case GETMAIL:
			pop3client();
			break;
			  
		  case SENDMAIL:
			smtpclient();
			break;
			
		  case STREAM:
			result = sendstream();
			if (result != OK)  ErrReport(result, "sendstream");
			break;
			
		  case HELP:
		  case VERSION:
			usage(dowhat[i]);
			break;
			
		  case TEMPLATE:
			if ((fp = fopen(outbox, "at")) == NULL)  {
				printf("cannot open outbox [%s]\n", outbox);
				break;
			}
			if ((sender = getsender()) == NULL)  {
				fprintf(fp, "\nFrom - %s\n", timenow());
				fprintf(fp, "From: \n");
			} else {
				fprintf(fp, "\nFrom %s %s\n", emailaddr(sender), 
						timenow());
				fprintf(fp, "From: %s\n", sender);
			}
			fprintf(fp, "To: \n");
			fprintf(fp, "Date: %s\n", timenow());
			fprintf(fp, "Subject: \n\n");
			fclose(fp);
			printf("Appended a template into %s\n", outbox);
			break;
			
		  default:
			printf("pmail: I don't hnow what I should do -- %d\n",
					dowhat[i]);
			usage(HELP);
			break;
		}
	}
	
	ReleaseVarity();
	return 0;
}


static int Option(int argc, char **argv)
{
	int		i, oidx, c;
	char	*sopt="votf:h:d:s:c:b:l:";
	char	*host = NULL, *fbox = NULL;
	char	buf[SVRBUFSIZ];
	struct	option	lopt[] = {
		{ "verbose", 0, NULL, 'v' },
		{ "host", 1, NULL, 'h' },
		{ "do", 1, NULL, 'd' },
		{ "list", 1, NULL, 'l' },
		{ "template", 0, NULL, 't' },
		{ "help", 0, NULL, HELP },
		{ "version", 0, NULL, VERSION },
		{ 0, 0, 0, 0 }
	};

	toaddr[0] = NULL;	
	while (1)  {
		c = getopt_long(argc, argv, sopt, lopt, &oidx);
		if (c == -1)  break;
		switch (c)  {
		  case HELP:
			dowhat[0] = HELP, dowhat[1] = -2;
			break;
			
		  case VERSION:
			dowhat[0] = VERSION, dowhat[1] = -2;
			break;
			
		  case 'v':
			verbose = ON;
			break;
			
		  case 't':
			dowhat[0] = TEMPLATE, dowhat[1] = -2;
			break;
			
		  case 'o':
			dowhat[0] = SENDMAIL, dowhat[1] = -2;
			break;
			
		  case 'h':
			if (host == NULL)  {
				host = (char*) malloc(strlen(optarg) + 1);
				if (host == NULL)  urgexit("option", LOWMEMORY);
				strcpy(host, optarg);
			}
			break;
			
		  case 'l':
			if (mailset == NULL)  {
				mailset = malloc((strlen(optarg)+1) * sizeof(int));
				if (mailset == NULL)  urgexit("option", LOWMEMORY);
				fillset(mailset, optarg);
			}
			break;
			
		  case 'f':
			if (fbox == NULL)  {
				fbox = (char*) malloc(strlen(optarg) + 1);
				if (fbox == NULL)  urgexit("option", LOWMEMORY);
				strcpy(fbox, optarg);
			}
			break;
			
		  case 's':
			if (subject == NULL)  {
				subject = (char*) malloc(strlen(optarg) + 1);
				if (subject == NULL)  urgexit("option", LOWMEMORY);
				strcpy(subject, optarg);
			}
			break;
			
		  case 'c':
			if (cc == NULL)  {
				cc = (char*) malloc(strlen(optarg) + 1);
				if (cc == NULL)  urgexit("option", LOWMEMORY);
				strcpy(cc, optarg);
			}
			break;
			
		  case 'b':
			if (bcc == NULL)  {
				bcc = (char*) malloc(strlen(optarg) + 1);
				if (bcc == NULL)  urgexit("option", LOWMEMORY);
				strcpy(bcc, optarg);
			}
			break;
						
						
		  case 'd':
			switch (*optarg)  {
			  case 'c':
				defop = OP_CHECK;
				break;
			
			  case 't':
				defop = OP_TOPHEAD;
				break;
				  
			  case 'd':
				defop = OP_DOWNLOAD;
				break;
				  
			  case 'f':
				defop = OP_FETCH;
				break;
				
			  case 'r':
				defop = OP_REMOVE;
				break;
				  
			  default:  defop = 0;
			}
			dowhat[0] = GETMAIL, dowhat[1] = -2;
			break;
			
		  default:
			dowhat[0] = HELP, dowhat[1] = -2;
		}
	}	
	if ((optind < argc) && (dowhat[1] != -2))  {
		dowhat[0] = STREAM, dowhat[1] = -2;
	}
	
	for (c=0; dowhat[c] >= 0; c++)  {
		switch (dowhat[c]) {
		  case GETMAIL:
			if (fbox == NULL)  strcpy(buf, HOMEBOX);
			else  strcpy(buf, fbox);
			combpath(buf);
			if ((optind < argc) || (host != NULL))  {
				strcpy(hosts[0].logid, "");
				strcpy(hosts[0].logpass, "*");
				strcpy(hosts[0].mailbox, buf);
				
				hosts[0].operate = defop;
				if (defop == 0)  hosts[0].operate = OP_DOWNLOAD;
				
				hostcnt = 0;
				if (host != NULL)  strcpy(hosts[hostcnt++].host, host);

				for (i = optind; i < argc; i++, hostcnt++)  {
					if (hostcnt > 0)  
						hosts[hostcnt] = hosts[hostcnt - 1];
					strcpy(hosts[hostcnt].host, argv[i]);
				}
			} else {
				for (i=0; i<hostcnt; i++)  {
					if (defop != 0)  hosts[i].operate = defop;
					if (fbox != NULL)  strcpy(hosts[i].mailbox, buf);
				}
			}
			pfree(fbox);
			pfree(host);
			break;	
				
		  case STREAM:
			for (i = optind; i < argc; i++)  {
				if ((i - optind + 1) == MAXHOSTS)  break;
				toaddr[ i - optind ] = argv[i];
			}
			toaddr[ i - optind ] = NULL;		
			if (host != NULL)  {
				pfree(smtpsvr);
				smtpsvr = (char*) malloc(strlen(host) + 1);
				if (smtpsvr == NULL)  urgexit("option", LOWMEMORY);
				strcpy(smtpsvr, host);
				pfree(fbox);
			}
			break;
			
		  case TEMPLATE:
			if (fbox != NULL)  {
				pfree(outbox);
				outbox = (char*) malloc(strlen(fbox) + 1);
				if (outbox == NULL)  urgexit("option", LOWMEMORY);
				strcpy(outbox, fbox);
				pfree(fbox);
				break;
			}
			if (optind < argc)  {
				pfree(outbox);
				outbox = (char*) malloc(strlen(argv[optind]) + 1);
				if (outbox == NULL)  urgexit("option", LOWMEMORY);
				strcpy(outbox, argv[optind]);
			}
			break;

		  case SENDMAIL:
			if (fbox != NULL)  {
				pfree(outbox);
				outbox = (char*) malloc(strlen(fbox) + 1);
				if (outbox == NULL)  urgexit("option", LOWMEMORY);
				strcpy(outbox, fbox);
				pfree(fbox);
			}
			if (host != NULL)  {
				pfree(smtpsvr);
				smtpsvr = (char*) malloc(strlen(host) + 1);
				if (smtpsvr == NULL)  urgexit("option", LOWMEMORY);
				strcpy(smtpsvr, host);
				pfree(fbox);
				break;
			}
			if (optind < argc)  {
				pfree(smtpsvr);
				smtpsvr = (char*) malloc(strlen(argv[optind]) + 1);
				if (smtpsvr == NULL)  urgexit("option", LOWMEMORY);
				strcpy(smtpsvr, argv[optind]);
			}
			break;
		}
	}

	pfree(fbox);
	pfree(host);
	
#ifdef		DEBUG	
	if (debuglvl > 0)  {
		FILE	*tmpfp;
		
		if (log > 0)  {
			tmpfp = fdopen(log, "a");
			testparam(tmpfp);
		} else  testparam(stdout);
	}
#endif
	return OK;
}


static void fillset(int *set, char *list)
{
	char	buf[SVRBUFSIZ], *p;
	int		i = 0;
	
	strcpy(buf, list);
	for (p = strtok(buf, ","); p != NULL; p = strtok(NULL, ","))  {
		if ((set[++i] = atoi(p)) < 0)  set[i] = 0;
		while (*p)  {
			if (*p++ == '-')  {
				set[++i] = -1;		/* bridge */
				if (*p)  set[++i] = atoi(p);  else  i--;
				break;
			}
		}
	}
	set[0] = i;
}



static void parsing(void)
{
	FILE	*fp;
	char	buf[SVRBUFSIZ];
	int		i;
	
	strcpy(buf, RCFILE);
	combpath(buf);
	if ((fp = fopen(buf, "rt")) == NULL)  {
		printf("pmail: cannot find option file [%s]\n", buf);
		exit(E_NORCFILE);
	}
	while (!feof(fp))  {
		if (fgets(buf, SVRBUFSIZ, fp) == NULL)  break;
		if (Strform(buf) == 0)  continue;
		
		if (!strncmp(buf, RC_DEFAULT, strlen(RC_DEFAULT)))
			rc_default(buf);
		else if (!strncmp(buf, RC_VERBOSE, strlen(RC_VERBOSE)))  
			verbose = ON;
		else if (!strncmp(buf, RC_TIMEOUT, strlen(RC_TIMEOUT)))
			timeout = rc_timeout(buf);
		else if (!strncmp(buf, RC_POP3HOST, strlen(RC_POP3HOST)))
			rc_pop3host(buf);
		else if (!strncmp(buf, RC_TOPNUM, strlen(RC_TOPNUM)))
			topn = rc_topnum(buf);
		else if (!strncmp(buf, RC_SMTP, strlen(RC_SMTP)))
			rc_smtp(buf);
		else if (!strncmp(buf, RC_OUTBOX, strlen(RC_OUTBOX)))
			rc_outbox(buf);
		else if (!strncmp(buf, RC_BAKBOX, strlen(RC_BAKBOX)))
			rc_bakbox(buf);
		else if (!strncmp(buf, RC_SENDER, strlen(RC_SENDER)))
			rc_sender(buf);
		else if (!strncmp(buf, RC_SIGNATURE, strlen(RC_SIGNATURE)))
			rc_signature(buf);
		else if (!strncmp(buf, RC_TOPSTYLE, strlen(RC_TOPSTYLE)))
			topstyle = rc_topstyle(buf);
		else if (!strncmp(buf, RC_DEALSENT, strlen(RC_DEALSENT)))
			dealsent = rc_dealsent(buf);
		else if (!strncmp(buf, RC_LOGFILE, strlen(RC_LOGFILE)))
			log = rc_logfile(buf);
		else if (!strncmp(buf, RC_LOGLIMIT, strlen(RC_LOGLIMIT)))
			loglimit = rc_loglimit(buf);
		else if (!strncmp(buf, RC_SIZELIMIT, strlen(RC_SIZELIMIT)))
			sizelimit = rc_sizelimit(buf);
		else if (!strncmp(buf, RC_PIPETO, strlen(RC_PIPETO)))
			rc_pipeto(buf);
		else if (!strncmp(buf, RC_HEADER, strlen(RC_HEADER)))
			rc_header(buf);
		else if (!strncmp(buf, RC_DEBUGLVL, strlen(RC_DEBUGLVL)))
			debuglvl = rc_debuglvl(buf);
		else  {
			fclose(fp);
			printf("pmail: Invalid option item [%s]\n", buf);
			exit(E_INVITEM);
		}
	}
	fclose(fp);
	for (i=0; i<headers; i++)  {
		if (!strncmp(headlst[i], "X-Mailer:", 9))  break;
	}
	if (i == headers)  {
		if (i >= HEADEREXT)  return;
		if ((headlst[i] = malloc(strlen(XMAILER) + 16)) == NULL)  {
			urgexit("option", LOWMEMORY);
		}
		sprintf(headlst[i], XMAILER, PMAILVER);
		headers++;
	}			
}	
		
static int Strform(char *buf)
{
	char	temp[SVRBUFSIZ], *p, *q;
	
	for (p = buf, q = temp; (*p > '\0') && (*p <= ' '); p++);
	
	for ( ; *p != '\0'; p++)  {
		if ((*p > '\0') && (*p <= ' '))  *q = ' ';
		else if (*p == '#')  break;
		else if (*p == '\\')  {
			if (*++p == '\0')  break;
			else {
				if (*q == ' ')  q++;
				*q++ = *p, *q = '\0';
			}
		} else {
			if (*q == ' ')  q++;
			*q++ = *p, *q = '\0';
		}
	}
	*q = '\0';
	
#ifdef		DEBUG
	
	if (debuglvl > 1)  {
		lowmsg((stderr, "Strform: << %s", buf));
		lowmsg((stderr, "Strform: >> [%s]\n", temp));
	}

#endif
	
	strcpy(buf, temp);
	return strlen(temp);
}


static int rc_default(char *p)
{
	char	buf[SVRBUFSIZ];
	int		i;
	
	dowhat[i=0] = -1;
	p += strlen(RC_DEFAULT);
	while ((*p > 0) && (*p <= ' '))  p++;
	strcpy(buf, p);
	if ((p = strtok(buf, ",")) == NULL)  return 0;
	
	do {
		while ((*p > 0) && (*p <= ' '))  p++;
		if (!strcmp(p, DEF_POP3))  dowhat[i++] = GETMAIL;
		else if (!strcmp(p, DEF_SMBOX))  dowhat[i++] = SENDMAIL;
		else if (!strcmp(p, DEF_TEMPLATE))  dowhat[i++] = TEMPLATE;
		else if (!strcmp(p, DEF_VERSION))  dowhat[i++] = VERSION;
		else if (!strcmp(p, DEF_HELP))  dowhat[i++] = HELP;
	} while ((p = strtok(NULL, ",")) != NULL);
	dowhat[i] = -1;
	return i;
}
	

static int rc_topnum(char *p)
{
	p += strlen(RC_TOPNUM);
	while ((*p > 0) && (*p <= ' '))  p++;
	return atoi(p);
}


static int rc_timeout(char *p)
{
	p += strlen(RC_TIMEOUT);
	while ((*p > 0) && (*p <= ' '))  p++;
	return atoi(p);
}

static void rc_smtp(char *p)
{
	p += strlen(RC_SMTP);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (smtpsvr == NULL)  {
		smtpsvr = (char*) malloc(strlen(p) + 1);
		if (smtpsvr == NULL)  urgexit("parse", LOWMEMORY);
		strcpy(smtpsvr, p);
	}
}

static void rc_outbox(char *p)
{
	char	buf[SVRBUFSIZ];
	
	p += strlen(RC_OUTBOX);
	while ((*p > 0) && (*p <= ' '))  p++;
	strcpy(buf, p);
	combpath(buf);
	if ((outbox = malloc(strlen(buf) + 1)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	strcpy(outbox, buf);
}


static int rc_logfile(char *p)
{
	char	buf[SVRBUFSIZ];
	struct	stat	fs;
	int		fd;
	
	p += strlen(RC_LOGFILE);
	while ((*p > 0) && (*p <= ' '))  p++;
	strcpy(buf, p);
	combpath(buf);
	if (!strcmp(buf, "stdout") || !strcmp(buf, "1"))  return 1;
	if (!strcmp(buf, "stderr") || !strcmp(buf, "2"))  return 2;
	fd = open(buf, O_WRONLY | O_APPEND | O_CREAT, S_IREAD | S_IWRITE);
	if (fstat(fd, &fs) < 0)  return -1;
	if (fs.st_size > loglimit)  ftruncate(fd, 0);
   	return fd;
}


static int rc_loglimit(char *p)
{
	p += strlen(RC_LOGLIMIT);
	while ((*p > 0) && (*p <= ' '))  p++;
	return atoi(p);
}
	
	
static int rc_sizelimit(char *p)
{
	int		s;
	
	p += strlen(RC_SIZELIMIT);
	while ((*p > 0) && (*p <= ' '))  p++;
	s = atoi(p);
	switch (p[strlen(p)-1]) {
		case 'k':
		case 'K':
			s *= 1024;
			break;
		
		case 'm':
		case 'M':
			s *= 1024 * 1024;
			break;
	}
	if (s < 0) s = 0;
	return s;
}
	

static void rc_signature(char *p)
{
	char	buf[SVRBUFSIZ];
	struct	stat	fs;
	int		fd;
	
	p += strlen(RC_SIGNATURE);
	while ((*p > 0) && (*p <= ' '))  p++;
	strcpy(buf, p);
	combpath(buf);
	if ((stat(buf, &fs) < 0) || (fs.st_size == 0))  return;
	if ((signature = malloc(fs.st_size + 1)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	if ((fd = open(buf, O_RDONLY)) < 0)  {
		pfree(signature);
		return;
	}
	read(fd, signature, fs.st_size);
	signature[fs.st_size] = '\0';
	close(fd);
}


static void rc_bakbox(char *p)
{
	char	buf[SVRBUFSIZ];
	
	p += strlen(RC_BAKBOX);
	while ((*p > 0) && (*p <= ' '))  p++;
	strcpy(buf, p);
	combpath(buf);
	if ((bakbox = malloc(strlen(buf) + 1)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	strcpy(bakbox, buf);
}


static int rc_topstyle(char *p)
{
	p += strlen(RC_TOPSTYLE);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (!strcmp(p, DEF_SIMPLE))  return  SIMPLETOP;
	if (!strcmp(p, DEF_COMPLEX)) return  COMPLEXTOP;
	if (!strcmp(p, DEF_SMART))   return  SMARTOP;	
	return SMARTOP;
}

static void rc_pipeto(char *p)
{
	p += strlen(RC_PIPETO);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (pipeto != NULL)  return;
	if ((pipeto = malloc(strlen(p) + 1)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	strcpy(pipeto, p);
}

static int rc_dealsent(char *p)
{
	p += strlen(RC_DEALSENT);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (!strcmp(p, DEF_HOLD))  return  SENTHOLD;
	if (!strcmp(p, DEF_DELETE)) return  SENTDELETE;
	if (!strcmp(p, DEF_BACKUP))   return  SENTBACKUP;	
	return SENTHOLD;
}

static void rc_header(char *p)
{
	p += strlen(RC_HEADER);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (strchr(p, ':') == NULL) return;
	if (headers >= HEADEREXT)  return;
	if ((headlst[headers] = malloc(strlen(p) + 1)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	strcpy(headlst[headers], p);
	headers++;
}

static void rc_sender(char *p)
{
	p += strlen(RC_SENDER);
	while ((*p > 0) && (*p <= ' '))  p++;
	if (headers >= HEADEREXT)  return;
	if ((headlst[headers] = malloc(strlen(p) + 10)) == NULL)  {
		urgexit("option", LOWMEMORY);
	}
	sprintf(headlst[headers], "Sender: %s", p);
	headers++;
}

static int rc_debuglvl(char *p)
{
	p += strlen(RC_DEBUGLVL);
	while ((*p > 0) && (*p <= ' '))  p++;
	return atoi(p);
}

static void rc_pop3host(char *p)
{
	char	*r, buf[SVRBUFSIZ];
	
	p += strlen(RC_POP3HOST);
	while ((*p > 0) && (*p <= ' '))  p++;
	
	if (hostcnt >= MAXHOSTS)  return;
	bzero(&hosts[hostcnt], sizeof(struct POP3_SERVER));
	
	r = p;
	if ((p = strchr(p, ':')) == NULL)  return;
	*p++ = '\0';
	strncpy(hosts[hostcnt].host, r, POP3_HOST_L - 1);
	
	r = p;
	if ((p = strchr(p, ':')) == NULL)  {
		hosts[hostcnt].operate = OP_DOWNLOAD;
	} else {
		*p++ = '\0';
		if (*r == '\0')  hosts[hostcnt].operate = OP_DOWNLOAD;
		else  hosts[hostcnt].operate = *r;
	}
	
	r = p;
	if ((p = strchr(p, ':')) == NULL)  {
		strcpy(buf, HOMEBOX);
	} else {
		*p++ = '\0';
		if (*r == '\0')  strcpy(buf, HOMEBOX);
		else  strcpy(buf, r);
	}
	combpath(buf);
	strncpy(hosts[hostcnt].mailbox, buf, POP3_MAILBOX_L - 1);

	r = p;
	if ((p = strchr(p, ':')) != NULL)  {
		*p++ = '\0';
		strncpy(hosts[hostcnt].logid, r, POP3_LOGID_L - 1);
	}
		
	strncpy(hosts[hostcnt].logpass, p, POP3_LOGPASS_L - 1);
	hostcnt++;
}
	

/**************************************************************/
		
static void usage(int flag)
{
	char *ver="pmail %s, by Xuming <xuming@bigfoot.com>\n";

	char *msg = "\
Usage:\n\
 pmail [--help] [--version] [-v]\n\
   -v, --verbose    verbose mode\n\
\n\
 pmail -o [-f outbox] [[-h] smtp.server]\n\
   send mails stored in the outgoing mailbox\n\
\n\
 pmail -d<c|t|d|f|r> [-f inbox] [-l \"list\"] [[-h] pop3.server ...]\n\
   -d, --do <c|t|d|f|r>  Which acts as a POP3 client\n\
      c  check mailbox status in the server\n\
      t  print header or other informations only\n\
      d  download mails and remove them from server\n\
      f  fetch mails and reserve them in the server\n\
      r  remove mails from server\n\
   -f inbox            specifies a local mailbox\n\
   -l, --list \"...\"    specify the active mails for processing\n\
   [-h] pop3.server    specifies the POP3 server\n\
\n\
 pmail [-s subject] [-c cc-addr] [-b bcc-addr] [-h smtp.server]\n\
       to-addr [[to-addr] ...]\n\
\n\
 pmail -t [[-f] outbox]\n\
   -t, --template    appends a template to the outgoing mailbox\n";
   
	if (flag == VERSION)  printf(ver, PMAILVER); else  printf(msg);
}
	
	

#ifdef		DEBUG

static void testparam(FILE *fp)
{
	int		i;
	
	if (verbose == OFF)  fprintf(fp, "verbose = off\n");
	else  fprintf(fp, "verbose = on\n");
	fprintf(fp, "smtp server is [%s]\n", smtpsvr);
	if (outbox != NULL)  fprintf(fp, "outbox is [%s]\n", outbox);
	if (bakbox != NULL)  fprintf(fp, "bakbox is [%s]\n", bakbox);
	if (signature != NULL)  
		fprintf(fp, "signature are %d bytes\n", strlen(signature));
	fprintf(fp, "default pmail operating = %c\n", defop);
	fprintf(fp, "pop3 time out = %d\n", timeout);
	fprintf(fp, "use TOP nn %d\n", topn);
	fprintf(fp, "The TOP style is %d\n", topstyle);
	fprintf(fp, "Download mail is limited to %d\n", sizelimit);
	fprintf(fp, "What should it deal with sent mail: %d\n", dealsent);
	fprintf(fp, "debugging level is %d\n", debuglvl);
	fprintf(fp, "Subject is [%s]\n", subject);
	fprintf(fp, "Copy to [%s]\n", cc);
	fprintf(fp, "Bcc to [%s]\n", bcc);
	fprintf(fp, "log file description is [%d]\n", log);
	if (mailset != NULL)  {
		fprintf(fp, "Mailset is: ");
		for (i=0; i<mailset[0]; i++)  
			fprintf(fp, "%d, ", mailset[i+1]);
		fprintf(fp, "\n");
	}
	for (i=0; toaddr[i] != NULL; i++) 
		fprintf(fp, "Write to: %s\n", toaddr[i]);
	for(i=0; i<headers; i++)  
		fprintf(fp, "Get Head %d:  %s\n", i, headlst[i]);
	
	fprintf(fp, "Do what: ");
	for (i=0; dowhat[i] >= 0; i++)  {
		switch (dowhat[i])  {
		  case GETMAIL:
			fprintf(fp, "getmail ");
			break;
			
		  case SENDMAIL:
			fprintf(fp, "sendmail ");
			break;
		
		  case TEMPLATE:
			fprintf(fp, "template ");
			break;
			
		  case STREAM:
			fprintf(fp, "stream ");
			break;
			
		  case HELP:
			fprintf(fp, "help ");
			break;
			
		  case VERSION:
			fprintf(fp, "version ");
			break;
		}
	}
	
	fprintf(fp, "\ntotal %d hosts:\n", hostcnt);
	for (i=0; i<hostcnt; i++)  {
		fprintf(fp, "\n");
		fprintf(fp, "host:     [%s]\n", hosts[i].host);
		fprintf(fp, "logid:    [%s]\n", hosts[i].logid);
		fprintf(fp, "logpass:  [%s]\n", hosts[i].logpass);
		fprintf(fp, "mailbox:  [%s]\n", hosts[i].mailbox);
		fprintf(fp, "operater: [%c]\n", hosts[i].operate);
	}
	fflush(fp);
}


#endif
