
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<signal.h>
#include	<unistd.h>
#include	<errno.h>
#include	"defs.h"


static	FILE	*mboxfp = NULL;
static	long	*mailist = NULL;

static	FILE	*sfp = NULL;
static	int		socket = -1;


#define		SILENCE		0
#define		LIST		1
#define		STATUS		2


static int  Identify(int socket, struct POP3_SERVER *host);
static int Lister(int socket, int *num, int flag);
static int  GetHead(int socket, int num);
static int DownloadMails(int, struct POP3_SERVER *, int);
static int  Quit(int  socket);
static int RemoveMails(int socket, int num, int *set);
static int isinSet(int *set, int num);
static void IdPass(struct POP3_SERVER *host);
static void vareset(void);
static void pop3stop();


void pop3client(void)
{
	int		i, mailnum, result;
	
	signal(SIGHUP, pop3stop);
	signal(SIGINT, pop3stop);
	signal(SIGQUIT, pop3stop);
	signal(SIGTERM, pop3stop);
	signal(SIGALRM, pop3stop);

	for (i=0; i<hostcnt; i++)  {
		IdPass(&hosts[i]);
		printf("Trying POP3 host [%s] ...\n", hosts[i].host);
		if ((socket = OpenSocket(hosts[i].host, POP3_PORT)) < 0)  {
			ErrReport(socket, "socket");
			continue;
		}
		sfp = fdopen(socket, "r");
		if ((result = Identify(socket, &hosts[i])) != OK)  {
			ErrReport(result, "login");
			vareset();
			continue;
		}
		if ((result = Lister(socket, &mailnum, STATUS)) != OK)  {
			ErrReport(result, "list");
			vareset();
			continue;
		}
		if (mailnum > 0)  {
			switch (hosts[i].operate)  {
			  case OP_DOWNLOAD:
			  case OP_FETCH:
				result = DownloadMails(socket, &hosts[i], mailnum);
				if (result == OK)  Quit(socket);
				else  ErrReport(result, "download");
				elog("pop3", "download mails");
				break;
			
			  case OP_CHECK:
				result = Lister(socket, &mailnum, LIST);
				if (result == OK)  Quit(socket);
				else  ErrReport(result, "list");
				elog("pop3", "list mail status in the host");
				break;
			
			  case OP_TOPHEAD:
				result = GetHead(socket, mailnum);
				if (result == OK)  Quit(socket);
				else  ErrReport(result, "top");
				elog("pop3", "list detail description of remote mails");
				break;
				
			  case OP_REMOVE:
				result = RemoveMails(socket, mailnum, mailset);
				if (result == OK)  Quit(socket);
				else  ErrReport(result, "remove");
				elog("pop3", "remove mails from server");
				break;
			}
		} 
		
		putchar('\n');
		vareset();
	}	
}
		
		
static int  Identify(int socket, struct POP3_SERVER *host)
{
	char	buf[SVRBUFSIZ];
	
	if (readlh(sfp, buf, SVRBUFSIZ) <= 0)  return  LOOKERRNO;
	if (verbose == ON)  printf("<< %s", buf);
	if (buf[0] != '+')  return LOGIN_FAIL;

	printf("login into the host as %s\n", host->logid);
	
	sprintf(buf, "USER %s", host->logid);
	if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
		return  LOOKERRNO;
	}
	if (buf[0] != '+')  {
		Quit(socket);
		return LOGIN_FAIL;
	}

	sprintf(buf, "PASS %s", host->logpass);
	if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
		return  LOOKERRNO;
	}
	if (buf[0] != '+')  {
		Quit(socket);
		return LOGIN_FAIL;
	}
	
	bzero(host->logpass, POP3_LOGPASS_L);
	sprintf(buf, "login into %s as %s", host->host, host->logid);
	elog("pop3", buf);
	return  OK;
}


static int Lister(int socket, int *num, int flag)
{
	char	buf[SVRBUFSIZ], *p;
	int		i, mleng = 0;
	
	if (mailist == NULL)  {
		sprintf(buf, "STAT");
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return LOOKERRNO;
		}
		if (*buf != '+')  {
			Quit(socket);
			return FAILURE;
		}
		strtok(buf, " ");
		p = strtok(NULL, " ");
		*num = atoi(p);
		p = strtok(NULL, " ");
		mleng = atoi(p);
		
		if (*num > 0)  {
			sprintf(buf, "LIST");
			if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
				return  LOOKERRNO;
			}
			if (*buf == '+')  {		
				mailist = (long*) malloc((*num) * sizeof(long));
				if (mailist == NULL)  urgexit("list", LOWMEMORY);
				for (i=0; readline(sfp, buf, SVRBUFSIZ); i++)  {
					if (!strcmp(buf, ".\n"))  break;
					strtok(buf, " ");
					p = strtok(NULL, " ");
					mailist[i] = atoi(p);
				}
			}
		}
	}
	if (flag == STATUS)  {
		printf("%d mail(s) ready, total %d bytes\n", *num, mleng);
	} else if ((flag == LIST) && (mailist != NULL))  {
		for (i = 0; i < *num; i++)  {
			if (isinSet(mailset, i+1) == YES)  {
				printf("%3d# of %d, %6ld bytes\n", 
						i+1, *num, mailist[i]);
			}
		}
	} else if ((flag == LIST) && (mailist == NULL))  {
		elog("pop3", "LIST command doesn't supported by server");
		printf("%d mail(s) ready\n", *num);
	}
	return OK;
}


static int  GetHead(int socket, int num)
{
	int		i, flag;
	char	buf[SVRBUFSIZ], rtop[SVRBUFSIZ];
	
	for (i = 1; i <= num; i++)  {
		if (isinSet(mailset, i) == NO)  continue;
		
		sprintf(buf, "TOP %d %d", i, topn);
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return LOOKERRNO;
		}
		if (*buf != '+')  break;
		
		flag = 0;
		printf("Mail %d# of %d", i, num);
		if (mailist == NULL)  putchar('\n');
		else printf(", %ld bytes\n", mailist[i-1]);
		
		while (readline(sfp, buf, SVRBUFSIZ))  {
			if (!strcmp(buf, ".\n"))  break;
			if ((flag == 0) && (isblankline(buf) == YES))  {
				flag = 1;
				if (topstyle == SMARTOP)  fputs(rtop, stdout);
			}			
			if (flag == 1)  fputs(buf, stdout);
			else  {
				switch (topstyle)  {
				  case SIMPLETOP:
					if (strnicmp(buf, "From:", 5) == 0)  {
						fputs(buf, stdout);
					}
					break;
				  
				  case COMPLEXTOP:
					fputs(buf, stdout);
					break;
				
				  case SMARTOP:
					if (strnicmp(buf, "From:", 5) == 0)  {
						fputs(buf, stdout);
					} else  if (strnicmp(buf, "Subject:", 8) == 0)  {
						fputs(buf, stdout);
					} else if (strnicmp(buf, "Received:", 9) == 0)  {
						strcpy(rtop, buf);
					}
					break;
				}		/* end of switch (topstyle) */
			}
		}   /* end of while ()  */
		putchar('\n');
	}	/* end of for () */
	
	if ((i == 1) && (i <= num))  {
		elog("pop3", "TOP command doesn't supported by server");
		Lister(socket, &i, LIST);
	}
	return OK;
}
	

static int DownloadMails(int socket, struct POP3_SERVER *host, int num)
{
	int		i, cur;
	char	buf[SVRBUFSIZ];
	
	if ((mboxfp = fopen(host->mailbox, "at")) == NULL)  {
		return OPENFILERR;
	}
	for (i = 1; i <= num; i++)  {
		if (isinSet(mailset, i) == NO)  continue;
				
		printf("get mail %3d/%d ", i, num);
		if (mailist != NULL)  {
			printf("(%-6ld) ", mailist[i-1]);
			if (sizelimit && (mailist[i-1] >= sizelimit))  {
				printf("oversized (%dK limited), give up.\n",
						sizelimit / 1024);
				continue;
			}
		}
		if (verbose == ON)  printf("\n");
		sprintf(buf, "RETR %d", i);
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			pfclose(mboxfp);
			return MISSOCKET;
		}
		if (*buf != '+')  break;
		
		fprintf(mboxfp, "From - %s\n", timenow());
		if (mailist != NULL)  illustrate(0, mailist[i-1], 40);
		while ((cur = readline(sfp, buf, SVRBUFSIZ)) > 0)  {
			if (mailist != NULL)  illustrate(cur, 0, 0);
			if (!strcmp(buf, ".\n"))  break;
			
			if (*buf == '.') fputs(buf+1, mboxfp);
			else  fputs(buf, mboxfp);
		}
		fputs("\n", mboxfp);
		if (mailist != NULL)  illustrate(0, 0, 0);
		fflush(mboxfp);
		
		if (host->operate == OP_DOWNLOAD)  {
			sprintf(buf, "DELE %d", i);
			if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
				pfclose(mboxfp);
				return MISSOCKET;
			}
		}
	}
	pfclose(mboxfp);
	return OK;
}
					

static int  Quit(int  socket)
{
	return AskAnswer(sfp, socket, "QUIT", 0);
}


static int RemoveMails(int socket, int num, int *set)
{
	int		i;
	char	buf[SVRBUFSIZ];
	
	if (set == NULL)  {
		printf("No mail is removed\n");
		return OK;
	}
	for (i = 1; i <= num; i++)  {
		if (isinSet(set, i) == NO)  continue;
		
		printf("remove mail %3d of %d", i, num);
		if (mailist == NULL)  putchar('\n');
		else printf(", %ld bytes\n", mailist[i-1]);
		
		sprintf(buf, "DELE %d", i);
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return LOOKERRNO;
		}
	}
	return OK;
}
			 


static int isinSet(int *set, int num)
{
	int		i;
	
	if (set == NULL)  return YES;	
		/* null set is looked as full set */
	
	for (i = 1; i <= set[0]; i++)  {
		if (set[i] == -1)  {
			if ((num <= set[i+1])  && (num >= set[i-1]))  return YES;
			if ((num >= set[i+1])  && (num <= set[i-1]))  return YES;
		}
		if (num == set[i])  return YES;
	}
	return NO;
}


/*
   This function is invoked to check the ID item and PASSWD item
   in the POP3_SERVER structure before login into remote host. Because
   these two item may be unset in the 'pmailrc' for security reasom, we
   should entry them by hands.
*/

static void IdPass(struct POP3_SERVER *host)
{
	char	*pass, temp[64];
	
	while (isblankline(host->logid) == YES)  {
		fprintf(stderr, "%s login: ", host->host);
		fgets(host->logid, POP3_LOGID_L - 1, stdin);
		chop(host->logid);
		fflush(stdin);
	}
	strcpy(temp, host->logpass);
	pass = temp;
	if (*pass == '*')  {
		strcpy(pass, getpass("Enter key: "));
		putchar('\n');
	} else if (*pass == '\\')  pass++;
	strncpy(hosts->logpass, pass, POP3_LOGPASS_L - 1);
}


static void vareset(void)
{
	if (mboxfp != NULL)  pfclose(mboxfp);
	if (mailist != NULL)  pfree(mailist);
	if (socket != -1)  {
		close(socket);
		socket = -1;
	}
	if (sfp != NULL)  pfclose(sfp);
}


static void pop3stop()
{
	vareset();
	ReleaseVarity();
	exit(E_INT);
}

