#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#include	<signal.h>
#include	"defs.h"

#define	ismailfrom(buf)		(strnicmp((buf), "From:", 5) == 0)
#define	ismailto(buf)		(strnicmp((buf), "To:", 3) == 0)
#define	ismailcc(buf)		(strnicmp((buf), "Cc:", 3) == 0)
#define	ismailbcc(buf)		(strnicmp((buf), "Bcc:", 4) == 0)


static 	char	tempfile[80];
static	FILE	*fld = NULL;
static	struct	SENDTO	*send = NULL;
static	FILE	*pipefp = NULL;

static	int		socket = -1;
static	FILE	*sfp = NULL;


static int  OpenFolder(void);
static int AddToAddr(struct SENDTO *p, char *to);
static int delivery(int no);
static struct SENDTO *stInsert(struct SENDTO **hd);
static int CloseFolder(void);
static int ismailstart(char *p);
static int isheader(char *p);
static void smtpStop();


int smtpclient(void)
{
	char	buf[SVRBUFSIZ];
	int		mails, r;
	FILE	*fpbak;
	
    signal(SIGHUP, smtpStop);
	signal(SIGINT, smtpStop);
	signal(SIGQUIT, smtpStop);
	signal(SIGTERM, smtpStop);
	signal(SIGALRM, smtpStop);
						 
	switch (mails = OpenFolder())  {
		case 0:
			printf("No mail is ready to send\n");
			CloseFolder();
			return OK;
		
		case OPENFILERR:
			elog("OpenFolder", "can't open outgoing box");
			return mails;
		
		case CREATEFAIL:
			elog("OpenFolder", "fail to create temp file");
			return mails;
	
		case FAILURE:
			elog("OpenFolder", "Error in creating temp file");
			return mails;
	}
	
#ifdef	DEBUG
	if (debuglvl > 0)  {
		struct	DLVTO	*to;
		struct	SENDTO	*p;
		
		printf("The temporary file is [%s]\n", tempfile);
		for (p=send; p!=NULL; p=p->next)  {
			printf("Mail %d of %d, length %ld, seek in %ld\n",
					p->id, mails, p->mleng, p->msgseek);
			printf("  from: [%s], address is [%s]\n", p->from, 
					emailaddr(p->from));
			for (to=p->to; to!=NULL; to=to->next)  
				printf("  send to: [%s], address is [%s]\n", to->host,
						emailaddr(to->host));
		}
		printf("Press Enter to continue ...\n");
		getchar();
	}
#endif

	
	printf("%d mail(s) are ready for sending.\n", mails);
   	printf("Trying SMTP host [%s] ...\n", smtpsvr);
	if ((socket = OpenSocket(smtpsvr, SMTP_PORT)) < 0)  {
		ErrReport(socket, "smtp");
		CloseFolder();
		return socket;
	}
	sfp = fdopen(socket, "r");
	sprintf(buf, "connected %s for sending mail", smtpsvr);
	elog("smtp", buf);

	if (readlh(sfp, buf, SVRBUFSIZ) <= 0)  {
		ErrReport(MISCONNECT, "smtp");
		CloseFolder();
		return MISCONNECT;
	}
	if (atoi(buf) != 220)  {
		ErrReport(MISANSWER, "smtp");
		CloseFolder();
		return MISANSWER;
	} else if (verbose == ON)  printf("<< %s", buf);
		
	if ((r = delivery(mails)) != OK)  {
		ErrReport(r, "delivery");
		CloseFolder();
		return r;
	}
		
	sprintf(buf, "deliveried %d mails", mails);
	elog("smtp", buf);

	if ((dealsent == SENTBACKUP) && (bakbox != NULL))  {
		if ((fpbak = fopen(bakbox, "at")) != NULL)  {
			rewind(fld);
			while(fgets(buf, SVRBUFSIZ, fld) != NULL)  {
				fputs(buf, fpbak);
			}
			fclose(fpbak);
			truncate(outbox, 0);
		}
	}
		
	CloseFolder();
	return r;
}
	

	
static int  OpenFolder(void)
{
	FILE	*fp;
	struct	SENDTO	*p;
	char	buf[SVRBUFSIZ], buf1[SVRBUFSIZ];
	int		mails = 0, hf = S_COMMON, sq, i;
	
	strcpy(tempfile, TMPFILE);
	if ((fp = fopen(outbox, "rt")) == NULL)  return  OPENFILERR;
	if ((fld = fdopen(mkstemp(tempfile), "w+t")) == NULL)  {
		pfclose(fp);
		return  CREATEFAIL;
	}
	
	*buf = '\0';
	while (!feof(fp))  {
		while(!ismailstart(buf))  {
			if (fgets(buf, SVRBUFSIZ, fp) == NULL)  {
				pfclose(fp);
				return 	mails;		
			}
		}
		p = stInsert((struct SENDTO**) &send);
		if (p == NULL)  goto tmperr;
		p->id = ++mails;
		fputs(buf, fld);
		p->msgseek = ftell(fld);
		

		while (fgets(buf, SVRBUFSIZ, fp) != NULL)  {
			if (!isheader(buf))  break;
			else if (ismailfrom(buf))  hf = S_FROM;
			else if (ismailto(buf) || ismailcc(buf))  hf = S_TO;
			else if (ismailbcc(buf))  hf = S_BCC;
			else if (*buf > ' ')  hf = S_COMMON;
			switch (hf)  {
				case S_FROM:
					if (p->from == NULL)  {
						p->from = (char*) malloc(strlen(buf));
						if (p->from == NULL)  goto tmperr;
						strcpy(p->from, &buf[5]);
						chop(p->from);
					}
					break;
				case S_TO:
				case S_BCC:
					if (AddToAddr(p, buf))  goto tmperr;
					break;
			}
			if (hf != S_BCC)  {	/* remove bcc: from stream */
				p->mleng += strlen(buf);
				fputs(buf, fld);
			}
		}
		for (i=0; i<headers; i++)  {	/* copy headers in RC file */
			p->mleng += strlen(headlst[i]) + 1;
			fprintf(fld, "%s\n", headlst[i]);
		}
		fputs("\n", fld);  p->mleng++;
		
		
		fflush(fld);
		sq = ftell(fld);
		if (pipeto != NULL)  {
			sprintf(buf1, "%s >> %s", pipeto, tempfile);
			pipefp = popen(buf1, "w");
			if (pipefp == NULL)  elog("pipeto", buf1);
		}
		do {
			if (ismailstart(buf))  break;
			if (pipefp == NULL)  fputs(buf, fld);
			else  fputs(buf, pipefp);
		} while (fgets(buf, SVRBUFSIZ, fp) != NULL);
		
		if (signature != NULL)  {
			if (pipefp == NULL)  fputs(signature, fld);
			else  fputs(signature, pipefp);
		}
		if (pipefp != NULL)  {
			pclose(pipefp);
			pipefp = NULL;
			fseek(fld, 0L, SEEK_END);
		}
		fputs("\n", fld);
		p->mleng += ftell(fld) - sq + 1;
	}		/* end of while()  */

	pfclose(fp);
	return 	mails;		
		
tmperr:
	pfclose(fp);
	if (pipefp != NULL)  {
		pclose(pipefp);
		pipefp = NULL;
	}
	return FAILURE;
}


static struct SENDTO *stInsert(struct SENDTO **hd)
{
	struct	SENDTO	*p, *new;
	
	new = (struct SENDTO*) malloc(sizeof(struct SENDTO));
	if (new == NULL)  return NULL;
	
	if (*hd == NULL)  *hd = new;
	else {
		for (p = *hd; p->next != NULL; p = p->next);
		p->next = new;
	}
	
	new->from = NULL;
	new->to = NULL;
	new->mleng = 0;
	new->next = NULL;
	return new;
}

static int AddToAddr(struct SENDTO *p, char *to)
{
	struct	DLVTO	*new;
	char	buf[SVRBUFSIZ];
	int		i;
	
	if (ismailto(to) || ismailcc(to))  to += 3;
	else if (ismailbcc(to))  to += 4;
	for ( ; *to && (*to <= ' '); to++);
	strcpy(buf, to);
	
	if ((to = strtok(buf, ",")) != NULL)  {
		do {
			if (isblankline(to))  continue;
			for ( ; *to && (*to <= ' '); to++);
			
			new = (struct DLVTO*) malloc(sizeof(struct DLVTO));
			if (new == NULL)  return -1;
			
			new->host = (char*) malloc(strlen(to) + 1);
			if (new->host == NULL)  return -1;
			
			strcpy(new->host, to);
			i = strlen(new->host) - 1;
			if (new->host[i] == '\n')  new->host[i] = '\0';
			new->next = p->to;
			p->to = new;
		} while ((to = strtok(NULL, ",")) != NULL);
	}
	return 0;
}
			
	

static int delivery(int no)
{
	struct	SENDTO	*p;
	struct	DLVTO	*r;
	char	buf[SVRBUFSIZ], *tmp;
	
	sprintf(buf, "HELO %s", cuserid(NULL));
	if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
		return MISCONNECT;
	}
	if (atoi(buf) != 250)  {
		printf("HELO: %s", buf);
		AskAnswer(sfp, socket, "QUIT", 0);
		return MISANSWER;
	}
	
	for (p = send; p != NULL; p = p->next)  {
		if ((p->from == NULL) && 
				((p->from = getsender()) == NULL))  {
			printf("no return address. abort mail %d#\n", p->id);
			continue;
		}
		if ((p->to == NULL) || (p->to->host == NULL))  {
			printf("no destinative address. abort mail %d#\n", p->id);
			continue;
		}
		
		printf("send mail %3d/%d, (%-6ld) ", p->id, no, p->mleng);
		sprintf(buf, "MAIL FROM:<%s>", emailaddr(p->from));
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return MISCONNECT;
		}
		if (atoi(buf) != 250)  {
			AskAnswer(sfp, socket, "QUIT", 0);
			printf("MAIL FROM [%s]: %s", p->from, buf);
			return MISANSWER;
		}
		
		for (r = p->to; r != NULL; r = r->next)  {
			sprintf(buf, "RCPT TO:<%s>", emailaddr(r->host));
			if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
				return MISCONNECT;
			}
			if (atoi(buf) != 250)  {
				elog(r->host, buf);
				printf("Recipient to %s: %s\n", r->host, buf);
			}
		}
		
		sprintf(buf, "DATA");
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return MISCONNECT;
		}
		if (atoi(buf) != 354)  {
			AskAnswer(sfp, socket, "QUIT", 0);
			printf("DATA: %s", buf);
			return MISANSWER;
		}
		fseek(fld, p->msgseek, SEEK_SET);
		
		*buf = '.', tmp = buf + 1;
		illustrate(0, p->mleng, 40);
		while (fgets(tmp, SVRBUFSIZ - 1, fld) != NULL)  {
			if (ismailstart(tmp))  break;
			illustrate(strlen(tmp), 0, 0);
			if (*tmp == '.')  linesend(socket, buf);
			else  linesend(socket, tmp);
		}
		illustrate(0, 0, 0);
		sflush(socket);

		strcpy(buf, "\r\n.");
		if (AskAnswer(sfp, socket, buf, SVRBUFSIZ) != OK)  {
			return MISCONNECT;
		}
		if (atoi(buf) != 250)  {
			AskAnswer(sfp, socket, "QUIT", 0);
			printf("DOT: %s", buf);
			return MISANSWER;
		}
	}
	AskAnswer(sfp, socket, "QUIT", 0);
	return OK;
}
		

static int ismailstart(char *p)
{
	char	buf[SVRBUFSIZ];
	int		i;
	char	*week[] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", 
						"Sat" };
	char	*mon[] = { "Jan", "Feb", "Mar",  "Apr", "May", "Jun", 
						"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
						
	strcpy(buf, p);
	
	p = strtok(buf, " "); 
	if (!p)  return NO;
	if (strcmp(p, "From"))  return NO;
	
    p = strtok(NULL, " ");
	if (!p)  return NO;
	
	p = strtok(NULL, " ");
	if (!p)  return NO;
	for (i=0; i<7; i++)  if (!strcmp(p, week[i]))  break;
	if (i == 7)  return NO;
	
	p = strtok(NULL, " ");
	if (!p)  return NO;
	for (i=0; i<12; i++)  if (!strcmp(p, mon[i]))  break;
	if (i == 12)  return NO;
	
	p = strtok(NULL, " ");
	if (!p)  return NO;
	if (atoi(p) == 0)  return NO;
	
	p = strtok(NULL, " ");
	if (!p)  return NO;
	
	p = strtok(NULL, " ");
	if (!p)  return NO;
	if (atoi(p) == 0)  return NO;
	return YES;
}
		

static int isheader(char *p)
{
	if (isblankline(p))  return NO;
	if (*p <= ' ')  return YES;
	for ( ; (*p > ' ') && (*p != ':'); p++);
	if (*p == ':')  return YES;
	return NO;
}
	
		
static int CloseFolder(void)
{
	struct	SENDTO	*s;
	struct	DLVTO	*q, *r;
	
	for (s = send; s != NULL; )  {
		pfree(s->from);
		for (q = s->to; q != NULL; )  {
			pfree(q->host);
			r = q;
			q = q->next;
			pfree(r);
		}
		send = s;
		s = s->next;
		pfree(send);
	}
	if (fld != NULL)  pfclose(fld);
	unlink(tempfile); 
	if (pipefp != NULL)  {
		pclose(pipefp);
		pipefp = NULL;
	}
	
	if (sfp != NULL)  pfclose(sfp);
	if (socket != -1)  {
		close(socket);
		socket = -1;
	}
	return 0;
}
	
		
static void smtpStop()
{
	CloseFolder();
	ReleaseVarity();
	exit(E_INT);
}
					
